<title>Notifications -Best Leearning</title>
@extends('user.layouts.master')
@section('css')
<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700">
    <link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/argon.css" type="text/css">
    <link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/myapp.css" type="text/css">

@endsection
@section('user-content')
<div class="card mt-2">
        <!-- Card header -->
        <div class="card-header">
            <!-- Title -->
            <h5 class="h3 mb-0">Latest notifications</h5>
        </div>
        <!-- Card body -->
    <div class="card-body">
        @if ($datas->isEmpty())
                <div class="text-center py-3">
                    <p>You Have No Notification</p>
                </div>
        @else
            @foreach ($datas as $key => $data)
                <div class="timeline timeline-one-side" data-timeline-content="axis" data-timeline-axis-style="dashed">
                    <div class="">
                        <span class="timeline-step badge-success">
                            <i class="fas fa-bell"></i>
                        </span>
                        <div class="timeline-content">
                            <div class="d-flex justify-content-between pt-1">
                                <div>
                                    <span class="text-muted text-sm font-weight-bold text-uppercase">{{ $data->message_title }}</span>
                                </div>
                                <div class="text-right">
                                    <small class="text-muted"><i class="fas fa-clock mr-1"></i>{{ \Carbon\Carbon::parse($data->created_at)->format('d-m-y g:i A') }}</small>
                                </div>
                            </div>
                            <h6 class="text-sm mt-1 mb-0">{{ $data->message }}</h6>
                        </div>
                    </div>
                </div>
            @endforeach
        @endif
    </div>
</div>
@endsection
@section('js')
<script>
    function setAccount(account_id) {
        $('#deposit_account').val(account_id);

        $.ajax({
            url: "{{ route('user.deposit-account-info') }}",
            type: "POST",
            data: {
                _token: '{{csrf_token()}}',
                account_id: account_id,
            },
            success: function (data) {
                $('#deposit_area').show();
                $('#deposit_account_text').html('Account No: ' + data['account_no']);
                $('#deposit_account_guideline').html(data['guideline']);
            },
        });
    }
</script>
</script>
@endsection